/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.block.entity;

import net.adventurez.entity.DragonEntity;
import net.adventurez.entity.TheEyeEntity;
import net.adventurez.init.BlockInit;
import net.adventurez.init.ConfigInit;
import net.adventurez.init.EffectInit;
import net.adventurez.init.EntityInit;
import net.adventurez.init.TagInit;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class DragonEggEntity
extends BlockEntity {
    private int overallSummoningTick;
    private int overallHatchingTick;
    private int hatchTick;
    private int summoningTick;
    private boolean isHatchAble;

    public DragonEggEntity(BlockPos pos, BlockState state) {
        super(BlockInit.DRAGON_EGG_ENTITY, pos, state);
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.hatchTick = nbt.m_128451_("Hatch_Tick");
        this.isHatchAble = nbt.m_128471_("Hatch_Able");
        this.summoningTick = nbt.m_128451_("Summoning_Tick");
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128379_("Hatch_Able", this.isHatchAble);
        nbt.m_128405_("Hatch_Tick", this.hatchTick);
        nbt.m_128405_("Summoning_Tick", this.summoningTick);
    }

    public static void clientTick(Level world, BlockPos pos, BlockState state, DragonEggEntity blockEntity) {
        blockEntity.tick();
    }

    public static void serverTick(Level world, BlockPos pos, BlockState state, DragonEggEntity blockEntity) {
        blockEntity.tick();
    }

    public void m_6596_() {
        super.m_6596_();
        this.sendUpdate();
    }

    private void sendUpdate() {
        if (this.m_58904_() != null) {
            BlockState state = this.m_58904_().m_8055_(this.f_58858_);
            this.m_58904_().m_7260_(this.f_58858_, state, state, 3);
        }
    }

    private boolean isValid(Level world, BlockPos pos, BlockState state) {
        int stoneCounter3 = 0;
        BlockState rod_1 = world.m_8055_(pos.m_122012_().m_122029_());
        BlockState rod_2 = world.m_8055_(pos.m_122012_().m_122024_());
        BlockState rod_3 = world.m_8055_(pos.m_122019_().m_122029_());
        BlockState rod_4 = world.m_8055_(pos.m_122019_().m_122024_());
        if (rod_1.equals(Blocks.f_50489_.m_49966_()) && rod_2.equals(Blocks.f_50489_.m_49966_()) && rod_3.equals(Blocks.f_50489_.m_49966_()) && rod_4.equals(Blocks.f_50489_.m_49966_())) {
            for (int stoneCounter4 = -1; stoneCounter4 < 2; ++stoneCounter4) {
                for (int stoneCounter5 = -1; stoneCounter5 < 2; ++stoneCounter5) {
                    BlockState middleState = world.m_8055_(pos.m_122013_(stoneCounter4).m_122030_(stoneCounter5).m_7495_());
                    if (!middleState.m_60734_().equals(Blocks.f_50723_)) continue;
                    ++stoneCounter3;
                }
            }
            for (int stoneCounter = -2; stoneCounter < 3; ++stoneCounter) {
                for (int stoneCounter2 = -2; stoneCounter2 < 3; ++stoneCounter2) {
                    BlockState baseState = world.m_8055_(pos.m_122013_(stoneCounter).m_122030_(stoneCounter2).m_6625_(2));
                    if (!baseState.m_204336_(TagInit.PLATFORM_END_BLOCKS)) continue;
                    ++stoneCounter3;
                }
            }
        }
        return stoneCounter3 == 34;
    }

    private void tick() {
        this.updateTheEyeSummoning();
        this.updateDragonHatching();
    }

    private void updateDragonHatching() {
        if (ConfigInit.CONFIG.allow_dragon_hatching && !this.m_58904_().m_5776_()) {
            ++this.overallHatchingTick;
            if (this.overallHatchingTick == 20) {
                if (!this.isHatchAble) {
                    if (((ServerLevel)this.m_58904_()).m_8586_() != null && !((ServerLevel)this.m_58904_()).m_8586_().m_64099_()) {
                        return;
                    }
                    Player playerEntity = this.m_58904_().m_45924_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_() + 0.5, 2.5, true);
                    if (playerEntity != null && playerEntity.m_21023_(EffectInit.FAME)) {
                        this.enableEggHatching();
                    }
                } else {
                    ++this.hatchTick;
                    if (this.hatchTick % 60 == 0) {
                        for (int i = 0; i < 20; ++i) {
                            double d = (double)this.f_58858_.m_123341_() + (double)this.m_58904_().m_213780_().m_188501_();
                            double e = (double)this.f_58858_.m_123342_() + (double)this.m_58904_().m_213780_().m_188501_();
                            double f = (double)this.f_58858_.m_123343_() + (double)this.m_58904_().m_213780_().m_188501_();
                            ((ServerLevel)this.m_58904_()).m_8767_((ParticleOptions)ParticleTypes.f_123748_, d, e, f, 0, 0.0, 0.0, 0.0, 0.01);
                        }
                    }
                    if (this.hatchTick >= 598) {
                        this.m_58904_().m_46961_(this.f_58858_, false);
                        DragonEntity dragonEntity = (DragonEntity)EntityInit.DRAGON.m_20615_(this.m_58904_());
                        dragonEntity.m_7678_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.55, (double)this.m_58899_().m_123343_() + 0.5, 90.0f, 0.0f);
                        dragonEntity.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_58904_()), this.m_58904_().m_6436_(this.f_58858_), MobSpawnType.STRUCTURE, null, null);
                        dragonEntity.setSize(1);
                        this.m_58904_().m_7967_((Entity)dragonEntity);
                    }
                }
            }
            if (this.overallHatchingTick >= 20) {
                this.overallHatchingTick = 0;
            }
        }
    }

    private void updateTheEyeSummoning() {
        if (ConfigInit.CONFIG.allow_the_eye_summoning && this.m_58904_().m_8055_(this.f_58858_.m_7495_()).equals(Blocks.f_50723_.m_49966_()) && this.m_58904_().m_46472_() == Level.f_46430_) {
            ++this.overallSummoningTick;
            BlockState state = this.m_58900_();
            if (this.overallSummoningTick == 20 && this.isValid(this.m_58904_(), this.f_58858_, state)) {
                ++this.summoningTick;
                if (!this.m_58904_().m_5776_() && this.summoningTick >= 60) {
                    TheEyeEntity theEyeEntity = (TheEyeEntity)EntityInit.THE_EYE.m_20615_(this.m_58904_());
                    theEyeEntity.m_7678_((double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.55, (double)this.m_58899_().m_123343_() + 0.5, 90.0f, 0.0f);
                    theEyeEntity.m_6518_((ServerLevelAccessor)((ServerLevel)this.m_58904_()), this.m_58904_().m_6436_(this.f_58858_), MobSpawnType.STRUCTURE, null, null);
                    theEyeEntity.setEyeInvulnerabletime();
                    this.m_58904_().m_7967_((Entity)theEyeEntity);
                    this.m_58904_().m_46961_(this.f_58858_, false);
                }
            }
            if (this.overallSummoningTick >= 20) {
                this.overallSummoningTick = 0;
            }
            if (this.m_58904_().m_5776_() && this.summoningTick != 0) {
                if (this.summoningTick % 10 == 0) {
                    this.dragonAltartParticle(1);
                }
                if (this.summoningTick % 5 == 0) {
                    this.dragonAltartParticle(2);
                }
            }
        }
    }

    private void dragonAltartParticle(int distance) {
        double d = (double)this.f_58858_.m_122030_(distance).m_122013_(distance).m_123341_() + (double)this.f_58857_.f_46441_.m_188501_();
        double e = (double)this.f_58858_.m_6630_(1 - distance).m_123342_() + (double)this.f_58857_.f_46441_.m_188501_() * 2.0;
        double f = (double)this.f_58858_.m_122030_(distance).m_122013_(distance).m_123343_() + (double)this.f_58857_.f_46441_.m_188501_();
        double d1 = (double)this.f_58858_.m_122025_(distance).m_122013_(distance).m_123341_() + (double)this.f_58857_.f_46441_.m_188501_();
        double e1 = (double)this.f_58858_.m_6630_(1 - distance).m_123342_() + (double)this.f_58857_.f_46441_.m_188501_() * 2.0;
        double f1 = (double)this.f_58858_.m_122025_(distance).m_122013_(distance).m_123343_() + (double)this.f_58857_.f_46441_.m_188501_();
        double d2 = (double)this.f_58858_.m_122020_(distance).m_122030_(distance).m_123341_() + (double)this.f_58857_.f_46441_.m_188501_();
        double e2 = (double)this.f_58858_.m_6630_(1 - distance).m_123342_() + (double)this.f_58857_.f_46441_.m_188501_() * 2.0;
        double f2 = (double)this.f_58858_.m_122020_(distance).m_122030_(distance).m_123343_() + (double)this.f_58857_.f_46441_.m_188501_();
        double d3 = (double)this.f_58858_.m_122020_(distance).m_122025_(distance).m_123341_() + (double)this.f_58857_.f_46441_.m_188501_();
        double e3 = (double)this.f_58858_.m_6630_(1 - distance).m_123342_() + (double)this.f_58857_.f_46441_.m_188501_() * 2.0;
        double f3 = (double)this.f_58858_.m_122020_(distance).m_122025_(distance).m_123343_() + (double)this.f_58857_.f_46441_.m_188501_();
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d, e, f, 0.0, 0.0, 0.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d1, e1, f1, 0.0, 0.0, 0.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d2, e2, f2, 0.0, 0.0, 0.0);
        this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123810_, d3, e3, f3, 0.0, 0.0, 0.0);
    }

    public void enableEggHatching() {
        this.isHatchAble = true;
    }
}

